var _searchDir;
function searchDir()
{
	if (_searchDir != undefined)
		return _searchDir;
	
	var documentURL = document.valueForKey("fileURL");
	var documentPath = documentURL.path();
	
	_searchDir = documentPath.substring(0, documentPath.lastIndexOf('/') + 1);
	return _searchDir;
}

var _platformString;
function platform()
{
	if (_platformString != undefined)
		return _platformString;
	
	var boundsSize = document.rootLayer.bounds.size;
	if (boundsSize.equal(new Size(1024,768)) || boundsSize.equal(new Size(768,1024)))
		_platformString = "~ipad";
	else if (boundsSize.equal(new Size(2048,1536))	|| boundsSize.equal(new Size(1536,2048)))
		_platformString = "@2x~ipad";
	else if (boundsSize.width == 320 || boundsSize.height == 320)
		_platformString = "~iphone";
	else if (boundsSize.width == 640 || boundsSize.height == 640)
		_platformString = "@2x~iphone";
	else
	{
		var documentURL = document.valueForKey("fileURL");
		var documentPath = documentURL.absoluteString();
		
		if (documentPath.indexOf("~ipad") != -1)
			return "~ipad";
		else if (documentPath.indexOf("~iphone") != -1)
			return "~iphone";
	}
	
	return _platformString;
}

function fileExistsAtPath(filePath)
{
	var fileManagerClass = NSClassFromString("NSFileManager");
	var fileManager = objc_msgSend(fileManagerClass, "defaultManager");
	
	return objc_msgSend(fileManager, "fileExistsAtPath:", filePath);
}

function validImagePathForName(fileName)
{
	var basePath = searchDir() + fileName;
	var platformName = platform();
	
	var genericPath = basePath + ".png";
	var genericJPGPath = basePath + ".jpg";
	var platformPath = basePath + platformName + ".png";
	var platformJPGPath = basePath + platformName + ".jpg";

	var iphone2xPath = basePath + "@2x~iphone" + ".png";
	var iphone2xJPGPath = basePath + "@2x~iphone" + ".jpg";

	if (fileExistsAtPath(genericPath))
		return genericPath;
	else if (fileExistsAtPath(platformPath))
		return platformPath;

	else if (fileExistsAtPath(genericJPGPath))
		return genericJPGPath;
	else if (fileExistsAtPath(platformJPGPath))
		return platformJPGPath;
		
	else if (platformName == "~ipad" && fileExistsAtPath(iphone2xPath))
		return iphone2xPath;
	else if (platformName == "~ipad" && fileExistsAtPath(iphone2xJPGPath))
		return iphone2xJPGPath;
	
	print ("Failed to find image - " + fileName)
	return null;
}

function updateLayer (layer) {
	var name = layer.name;
	var lastChar = name.substring(name.length - 1, name.length);
	
	if (lastChar == "*")
	{
		var imagePath = validImagePathForName(name.substring(0, name.length - 1));
		
		if (imagePath != null)
		{
			var imageURL = URL.fileURLWithPath(imagePath);
			layer.contents = new Image(imageURL);
		}
	}

    var sublayers = layer.sublayers;
    if (sublayers) {
		var count = sublayers.length;
		for (var i = 0; i < count; i++)
			updateLayer (sublayers[i]);
    }
    if (layer.mask)
		updateLayer (layer.mask);
}

updateLayer (document.rootLayer);
